% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classPrior.R
\name{createPriorDensity}
\alias{createPriorDensity}
\title{Fits a density function to a multivariate sample}
\usage{
createPriorDensity(sampler, method = "multivariate", eps = 1e-10,
  lower = NULL, upper = NULL, best = NULL, ...)
}
\arguments{
\item{sampler}{an object of class BayesianOutput or a matrix}

\item{method}{method to generate prior - default and currently only option is multivariate}

\item{eps}{numerical precision to avoid singularity}

\item{lower}{vector with lower bounds of parameter for the new prior, independent of the input sample}

\item{upper}{vector with upper bounds of parameter for the new prior, independent of the input sample}

\item{best}{vector with "best" values of parameter for the new prior, independent of the input sample}

\item{...}{parameters to pass on to the getSample function}
}
\description{
Fits a density function to a multivariate sample
}
\examples{
# Create a BayesianSetup
ll <- generateTestDensityMultiNormal(sigma = "no correlation")
bayesianSetup = createBayesianSetup(likelihood = ll, 
                                    lower = rep(-10, 3), 
                                    upper = rep(10, 3))

settings = list(iterations = 2500)
out <- runMCMC(bayesianSetup = bayesianSetup, settings = settings)


newPrior = createPriorDensity(out, method = "multivariate",
                              eps = 1e-10, lower = rep(-10, 3),
                              upper =  rep(10, 3), best = NULL)

bayesianSetup <- createBayesianSetup(likelihood = ll, prior = newPrior)

settings = list(iterations = 1000)
out <- runMCMC(bayesianSetup = bayesianSetup, settings = settings)

}
\seealso{
\code{\link{createPrior}} \cr
         \code{\link{createBetaPrior}} \cr
         \code{\link{createTruncatedNormalPrior}} \cr
         \code{\link{createUniformPrior}} \cr
         \code{\link{createBayesianSetup}} \cr
}
