% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanfitExtended.R
\docType{class}
\name{stanfitExtended}
\alias{stanfitExtended}
\title{\code{stanfitExtended}, an S4 class inherited
from the S4 class \strong{\emph{\code{stanfit}}}}
\description{
Inherits from the class \strong{\emph{\code{stanfit}}} which
is an S4 class defined in  the package \pkg{rstan} :
}
\details{
Revised in 2019.Jun 5
         Revised in 2019 Oct 19
         Revised in 2019 Nov 25


   --------   To read the table of \R object of class \code{stanfit} in case of MRMC  ----------------------------


  * The  AUC denoted by \code{AA[modalityID , readerID]} are shown.

    For example, \code{AA[2,3]} means the AUC of the 2 nd modality and the 3 rd reader.

  * The column of \code{2.5\%} and \code{97.5\%} means the lower and upper bounds of the 95% Credible Interval (posterior interval) of AUCs.
}
\section{Slots}{

\describe{
\item{\code{plotdataMRMC}}{Plot data for MRMC case.}

\item{\code{plotdata}}{This is a data frame with four
components which is used to draw curves
such as FROC curves and AFROC curves.
So, this slot includes the component:


\code{ fit@plotdata$x.AFROC, }

\code{fit@plotdata$y.AFROC, }

\code{fit@plotdata$x.FROC, }

\code{fit@plotdata$y.FROC }

where \code{fit} is an
object of class \code{stanfitExtended}.

For example, we can use this slot

# E.g.

  \code{plot(f@plotdata$x.FROC,f@plotdata$y.FROC,xlim=c(0,1),type="l")}


#Or


 \code{plot(f@plotdata$x.AFROC, f@plotdata$y.AFROC, type="l" ) }


The author think this slot is not good
because it increases the object size.}

\item{\code{dataList}}{An FROC dataset, to which a model is fitted.}

\item{\code{dataList.Name}}{whose class is "character", indicating the name of data object. This data object is fitted a model.}

\item{\code{multinomial}}{A logical, if true, then the classical, traditional model is fitted, which is not the author's model.}

\item{\code{studyDesign}}{A character, e.g.,
"srsc.per.image",  "srsc.per.lesion",
 according to False Positive Fraction (FPF) is per image or per lesion.}

\item{\code{metadata}}{An additional data
calculated from dataList,
 such as cumulative hits and false alarms,...,etc.}

\item{\code{WAIC}}{A WAIC calculated
by the function \strong{\emph{\code{\link{waic}}}} .}

\item{\code{convergence}}{A logical \R object TRUE or FALSE. If TRUE,
then the model is good in the R hat criterion.}

\item{\code{PreciseLogLikelihood}}{A logical. If TRUE,
then target formulation is used. In the past, the author made a target and non-target model, but now
the model is declared by target only, so, this slot is now, redandunt.}

\item{\code{chisquare}}{This is a chi square at  the posterior mean estimates.
Chi square statistic is \eqn{\chi^2 (Data|\theta)},
there are three simple ways to get it.

(1) \eqn{ \int \chi^2(Data|\theta ) \pi(\theta|Data)d\theta }

(2) \eqn{  \chi^2(Data|\int \theta \pi(\theta|Data)d\theta) }

(3) \eqn{ \int \chi^2(Data|\theta ) f(Data|\theta)\pi(\theta|Data)d\theta }

where, \eqn{f( Data|\theta )} denotes a likelihood and \eqn{\pi(\theta| Data )} is a posterior.
This slot retains the (2)

See also \code{\link{ppp}()}}

\item{\code{index}}{An  object of numeric class. This is for programming phase.}

\item{\code{Divergences}}{This is the number of the
divergence transitions in the MCMC simulation.}

\item{\code{MCMC.Iterations}}{A MCMC iterations which
does not count the burn-in period.}

\item{\code{Divergence.rate}}{A divergence rate,
calculated by dividing the number of the divergence
iterations by total MCMC iterations except Burn-in period is not included.}

\item{\code{model_name}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class defined in the \strong{\emph{rstan }}package.}

\item{\code{model_pars}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{par_dims}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{mode}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{sim}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{inits}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{stan_args}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{stanmodel}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{date}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}

\item{\code{.MISC}}{A slot of the \strong{\emph{\code{stanfit}}} which is an S4 class in the package \strong{\emph{rstan}}.}
}}

