% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoronaVirus_Disease_2019.R
\name{CoronaVirus_Disease_2019}
\alias{CoronaVirus_Disease_2019}
\title{Who should be inspected?}
\usage{
CoronaVirus_Disease_2019(N, n, se, sp)
}
\arguments{
\item{N}{The number of population, including diseased and non-diseased people}

\item{n}{The number of diseased population}

\item{se}{Sensitivity of a diagnostic test}

\item{sp}{Specificity of a diagnostic test}
}
\value{
Probability which is between 0 and 1. I you want to get percent,
 then it is 100 times the return value.

\deqn{Prob(Truth = diseased | Diagnosis = Positive) = \frac{Se\times n}{Se \times n + (N-n)\times(1-sp)}   }
}
\description{
Even if a diagnosis test with respect to "all" said
that it is positive, however the result cannot be correct in high probability.
If we test no suspicous people, then it reduce our resource of diagnosis test
and when some suspicous people needs the test, we cannot do the test.

So, the diagnosis test should be done for the suspicous people only. Not should be done
for all people including no suspicous people. The medical resource is finite, we should use it
for more optimal way.
}
\details{
--------------------------------------------------------------------------
\tabular{llll}{

 Diagnosis \ truth   \tab \strong{ Diseased } \tab \strong{   Non-diseased}  \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
 Positive   \tab   se*n     \tab  \eqn{(N-n)(1-sp)}                 \cr
 Negative   \tab   (1-se)*n \tab  \eqn{(N-n)sp}             \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
        \tab   n \tab  \eqn{N-n}      \cr
 }
-------------------------------------------------------------------------


For example,

  if prevalence is 0.0001,

   population is 10000,

specificity = 0.8,

sensitivity = 0.9,


  then the table is the following.

  We can calculates the probability of the event that
  a one whose diagnosis is positive is really diseased
  is

  \deqn{  \frac{9}{1998 + 9} = 9/(1998+9) = 0.00448  }


--------------------------------------------------------------------------
\tabular{llll}{

 Diagnosis \ truth   \tab \strong{ Diseased } \tab \strong{   Non-diseased}  \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
 Positive   \tab   9     \tab   1998                \cr
 Negative   \tab   1 \tab   7992            \cr
    -----------------------\tab -----------------------   \tab ------------- \cr
        \tab   \eqn{n = 10} \tab  \eqn{N-n=10000-10}      \cr
 }
-------------------------------------------------------------------------
}
\examples{

CoronaVirus_Disease_2019(10000,10,0.9,0.8)

9/(1998+9)



}
