\name{Jointness}
\alias{Jointness}
\title{
Computation of Jointness measurements.
}
\description{
\code{Jointness} computes the joint inclusion probabilitiy of two given covariates as well as the jointness measurements of Ley and Steel (2007)}
\usage{
Jointness(x, covariates="All")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{An object of class \code{Bvs}}
  \item{covariates}{It can be either "All"(default) or a vector contaning the name of  two covariates. }
}
\value{ An object of class \code{jointness} is returned.  

If \code{covariates} is "All" this object is a list with three matrices containg different jointness measurements for all pairs of covariates is returned.  In particular, for covariates i and j the jointness measurements are: 

The Joint inclusion probabilities:

\eqn{P(i \cap j)}

And the two measurements of Ley and Steel (2007)

\eqn{\mathcal{j}^*= \frac{P(i \cap j)}{P(i\cup j)}}

\eqn{\mathcal{j}^*=\frac{P(i \cap j)}{P(i\cup j)-P(i\cap j)}}

If \code{covariates} is a two dimensional vector, \code{Jointness} return a list of two elements. The first one of them is a data frame containing the measurements above but  just for the given pair of covariates. The second element is the \code{covariates} vector.

If method \code{print.jointness} is used a message with the meaning of the measurement si printed. 
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

Maintainer: <anabel.forte@uv.es>
}
\references{

 Ley, E. and Steel, M.F.J. (2007)<DOI:10.1016/j.jmacro.2006.12.002>Jointness in Bayesian variable selection with applications to growth regression. Journal of Macroeconomics, 29(3):476-493.
}

\keyword{ package }
\seealso{
\code{\link[BayesVarSel]{Bvs}}, \code{\link[BayesVarSel]{PBvs}}, \code{\link[BayesVarSel]{GibbsBvs}} for performing variable selection and obtaining an object of class \code{Bvs}.

\code{\link[BayesVarSel]{plotBvs}} for different descriptive plots of the results, \code{\link[BayesVarSel]{BMAcoeff}} for obtaining model averaged simulations of regression coefficients and \code{\link[BayesVarSel]{predictBvs}} for predictions.
}

\examples{
\dontrun{
#Analysis of Crime Data
#load data

data(UScrime)

crime.Bvs<- Bvs(formula="y~.", data=UScrime, n.keep=1000)

#A look at the jointness measurements:
Jointness(crime.Bvs, covariates="All")

Jointness(crime.Bvs, covariates=c("Ineq","Prob"))
#---------
#The joint inclusion probability for Ineq and Prob is:  0.65 
#---------
#The ratio between the probability of including both 
#covariates and the probability of including at least one of then is: 0.66
#---------
#The probability of including both covariates at the same times is 1.95 times 
#the probability of including one of them alone 

}}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
