% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-fit.R
\name{JAGS_check_convergence}
\alias{JAGS_check_convergence}
\title{Assess convergence of a runjags model}
\usage{
JAGS_check_convergence(
  fit,
  prior_list,
  max_Rhat = 1.05,
  min_ESS = 500,
  max_error = 0.01,
  max_SD_error = 0.05
)
}
\arguments{
\item{fit}{a runjags model}

\item{prior_list}{named list of prior distribution
(names correspond to the parameter names)}

\item{max_Rhat}{maximum R-hat error for the autofit function.
Defaults to \code{1.05}.}

\item{min_ESS}{minimum effective sample size. Defaults to \code{500}.}

\item{max_error}{maximum MCMC error. Defaults to \code{1.01}.}

\item{max_SD_error}{maximum MCMC error as the proportion of standard
deviation of the parameters. Defaults to \code{0.05}.}
}
\value{
\code{JAGS_check_convergence} returns a boolean
indicating whether the model converged or not, with an
attribute 'errors' carrying the failed convergence checks (if any).
}
\description{
Checks whether the supplied \link[runjags]{runjags-package} model
satisfied convergence criteria.
}
\examples{
# simulate data
set.seed(1)
data <- list(
  x = rnorm(10),
  N = 10
)
data$x

# define priors
priors_list <- list(mu = prior("normal", list(0, 1)))

# define likelihood for the data
model_syntax <-
  "model{
    for(i in 1:N){
      x[i] ~ dnorm(mu, 1)
    }
  }"

# fit the models
fit <- JAGS_fit(model_syntax, data, priors_list, seed = 0)
JAGS_check_convergence(fit, priors_list)

}
\seealso{
\code{\link[=JAGS_fit]{JAGS_fit()}}
}
