% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamplePosteriorDepGamma.R
\name{SamplePosteriorDepGamma}
\alias{SamplePosteriorDepGamma}
\title{Draw samples from the posterior for the hazard, using the piecewise
exponential (histogram) prior with dependent Gamma heights}
\usage{
SamplePosteriorDepGamma(
  failures,
  exposures,
  N = 1000,
  alpha.dep = 1,
  alpha0.dep = 1.5,
  beta0.dep = 1
)
}
\arguments{
\item{failures}{A vector of length \eqn{K} (the total number of intervals),
containing for each interval the number of individuals who had an event
during that interval.}

\item{exposures}{A vector of length \eqn{K} (the total number of intervals),
containing for each interval the total amount of time all individuals
together were under follow-up during that interval.}

\item{N}{The number of draws to take.}

\item{alpha.dep}{The main parameter \eqn{\alpha} for the dependent Gamma
prior, as described in the documentation for \link{BayesSurv}. It is
recommended to take \code{alpha.dep} smaller than \code{alpha0.dep}.}

\item{alpha0.dep}{The shape parameter for the Gamma prior on the histogram
height for the first interval. It is recommended to take \code{alpha.dep}
smaller than \code{alpha0.dep}.}

\item{beta0.dep}{The rate parameter for the Gamma prior on the histogram
height for the first interval.}
}
\value{
\item{samples}{A \eqn{N} by \eqn{K} (the number of draws by the
number of intervals) matrix, with each row containing a draw from the
posterior for the hazard, based on a histogram prior with dependent
Gamma heights.}
}
\description{
The sampler is described in the Supplement to Castillo and Van der Pas
(2020) and uses MCMC within Gibbs, with a Gamma proposal with shape
parameter equal to the number of events in each interval plus some epsilon
(to prevent proposals equal to zero if there are no events in an interval)
and rate parameter equal to the parameter alpha (set by the user) divided by
histogram height on the previous interval, plus the total amount of time all
individuals were exposed during this interval. Most users of the package will
not work with this function directly, but instead use the main function
\link{BayesSurv}, in which this particular function is incorporated.
}
\details{
The samples returned by this function are draws from the posterior for the
hazard function. To obtain draws from the posterior for the cumulative
hazard, one can use numerical integration. One way to achieve this is by
first finding the values of the cumulative hazard at the end of each interval,
e.g. by \code{t(apply(samples*time.max/K, 1, cumsum))}, where \code{samples}
is the output from the present function and \code{time.max} and \code{K} are
as described for \link{BayesSurv}, and then using \code{approxfun()} to linearly
interpolate in between. To obtain posterior samples from the survival, one
could then use \link{SurvivalFromCumhaz}.
}
\references{
Castillo and Van der Pas (2020). Multiscale Bayesian survival
  analysis. <arXiv:2005.02889>.
}
\seealso{
\link{BayesSurv}, which computes the posterior mean and credible
  bands for the cumulative hazard and survival functions, as well as the
  posterior mean for the hazard. Within \link{BayesSurv}, the present
  function is called.
}
