% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEstimator.R
\name{plotEstimator}
\alias{plotEstimator}
\title{plot the estimators}
\usage{
plotEstimator(
  x,
  estimator = NULL,
  colorScale.gamma = grey((100:0)/100),
  colorScale.beta = c("blue", "white", "red"),
  legend.cex.axis = 1,
  name.responses = NA,
  name.predictors = NA,
  xlab = "",
  ylab = "",
  fig.tex = FALSE,
  output = "ParamEstimator",
  header = "",
  header.cex = 2,
  tick = FALSE,
  mgp = c(2.5, 1, 0),
  title.beta = paste("Estimator", "$\\\\hat{\\\\bm{B}}$"),
  title.gamma = paste("Estimator", "$\\\\hat{\\\\mathbf{\\\\Gamma}}$"),
  title.Gy = paste("Estimator", "$\\\\hat{\\\\mathcal{G}}$"),
  cex.main = 1.5,
  ...
)
}
\arguments{
\item{x}{an object of class \code{BayesSUR}}

\item{estimator}{print the heatmap of estimators. The value "beta" is for the estimated coefficients matrix, "gamma" for the latent indicator matrix and "Gy" for the graph of responses}

\item{colorScale.gamma}{value palette for gamma}

\item{colorScale.beta}{a vector of three colors for diverging color schemes}

\item{legend.cex.axis}{magnification of axis annotation relative to cex}

\item{name.responses}{a vector of the response names. The default is "NA" only to show the locations. The value "auto" show the response names from the orginal data.}

\item{name.predictors}{a vector of the predictor names. The default is "NA" only to show the locations. The value "auto" show the predictor names from the orginal data.}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{fig.tex}{print the figure through LaTex. Default is "FALSE"}

\item{output}{the file name of printed figure}

\item{header}{the main title}

\item{header.cex}{size of the main title for all estimators}

\item{tick}{a logical value specifying whether tickmarks and an axis line should be drawn. Default is "FALSE"}

\item{mgp}{the margin line (in mex units) for the axis title, axis labels and axis line}

\item{title.beta}{a title for the printed "beta" if \code{fig.tex=TRUE}}

\item{title.gamma}{a title for the printed "gamma" if \code{fig.tex=TRUE}}

\item{title.Gy}{a title for the printed "Gy" if \code{fig.tex=TRUE}}

\item{cex.main}{size of the title for each estimator}

\item{...}{other arguments}
}
\description{
Plot the posterior mean estimators from a "BayesSUR" class object, including the coefficients beta, latent indicator variable gamma and graph of responses.
}
\examples{
data("exampleEQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

set.seed(9173)
fit <- BayesSUR(Y = exampleEQTL[["blockList"]][[1]], 
                X = exampleEQTL[["blockList"]][[2]],
                data = exampleEQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check output
# Plot the estimators from the fitted object
plotEstimator(fit, estimator=c("beta","gamma","Gy"))

\dontrun{
#Set up temporary work directory for saving a pdf figure
td <- tempdir()
oldwd <- getwd()
setwd(td)

# Produce authentic math formulas in the graph
plotEstimator(fit, estimator=c("beta","gamma","Gy"), fig.tex = TRUE)
system(paste(getOption("pdfviewer"), "ParamEstimator.pdf"))
setwd(oldwd)
}

}
