% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot}
\alias{plot}
\alias{plot.bsim}
\alias{plot.bsimPred}
\title{Plot Method for \code{BayesSIM}}
\usage{
\method{plot}{bsim}(x, method = c("mean", "median"), interval = TRUE, alpha = 0.95, ...)

\method{plot}{bsimPred}(x, ...)
}
\arguments{
\item{x}{A fitted object of \code{BayesSIM} or individual model.}

\item{method}{Character string specifying the summary used for the
posterior fitted values. Options are \code{"mean"} or \code{"median"}.
Default is \code{"mean"}.}

\item{interval}{A logical value indicating whether a credible interval is included in the fitted plot. Default is \code{TRUE}.}

\item{alpha}{Numeric value between 0 and 1 specifying the credible level.
By default, \code{alpha = 0.95} produces a 95\% credible interval.}

\item{...}{Additional arguments passed to underlying plotting functions.}
}
\value{
The output consists of two plots:
\enumerate{
\item \strong{Observed vs Predicted plot}: a diagnostic scatter plot comparing
actual outcomes with posterior fitted values to visually assess model fit.
\item \strong{Fitted curve plot}: posterior \eqn{\hat{y}} as a function of the
estimated single index, optionally with \eqn{100 \times \alpha} \% credible intervals.
}
}
\description{
Produce diagnostic plots for a fitted Bayesian single-index model.
}
\details{
The function internally calls \code{\link[=predict]{predict()}} on the fitted model object
to obtain posterior summaries of \eqn{\hat{y}}. Predicted value of \eqn{y} is \eqn{\hat{f}(X'\hat{\theta})}.
\itemize{
\item If \code{interval = TRUE}, the function requests posterior credible intervals
and overlays them on the fitted curve.
\item If \code{interval = FALSE}, only the posterior mean or median curve is drawn.
}
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)

# 1. One tool version
fit_one <- BayesSIM(y ~ ., data = simdata2,
                    niter = 5000, nburnin = 1000, nchain = 1)

# Check median index vector estimates with standard errors
coef(fit_one, method = "median", se = TRUE)

# Fitted index values of median prediction
fitted(fit_one, type = "linpred", method = "median")

# Residuals of median prediction
residuals(fit_one, method = "median")

# Summary of the model
summary(fit_one)

# Convergence diagnostics
nimTraceplot(fit_one)

# Goodness of fit
GOF(fit_one)

# Fitted plot
plot(fit_one)

# Prediction with 95\% credible interval at new data
newx <- data.frame(X1 = rnorm(3), X2 = rnorm(3), X3 = rnorm(3), X4 = rnorm(3))
pred <- predict(fit_one, newdata = newx, interval = "credible", level = 0.95)
plot(pred)


# 2. Split version
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                    nchains = 1, setSeed = TRUE, inits = initList,
                    summary = TRUE, samplesAsCodaMCMC = TRUE)

# "fit_split" becomes exactly the same as the class of "fit_one" object and apply generic functions.
fit_split <- as_bsim(models, mcmc.out)

}
}
\seealso{
\code{\link[=predict.bsim]{predict.bsim()}}, \code{\link[=summary.bsim]{summary.bsim()}}
}
