% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_spline.R
\name{predict.bsimSpline}
\alias{predict.bsimSpline}
\title{Predict method for \code{bsimSpline} objects}
\usage{
\method{predict}{bsimSpline}(
  object,
  newdata = NULL,
  method = "mean",
  se.fit = FALSE,
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{An object of class \code{bsimSpline} created with MCMC sampling
enabled.}

\item{newdata}{A \code{data.frame} of predictors for prediction. The columns
must match the columns of train data. If a column named \code{"y"} is present, it is treated as the observed response
and is used to compute RMSE and to draw fitted plots. If \code{NULL},
fitted values with train data are summarized.}

\item{method}{A character scalar selecting the point estimator returned in the
summary: \code{"mean"} (posterior mean) or \code{"median"} (posterior median).}

\item{se.fit}{Logical; if \code{TRUE}, include posterior standard deviation and
interval bounds in the returned summary and shaded area for the interval
in the fitted curve plot.}

\item{level}{Numeric scalar in \eqn{[0, 1]}; nominal coverage for intervals. By default, \code{level = 0.95}.}

\item{...}{Further arguments passed to \code{\link{predict}}.}
}
\value{
A \code{list} with components:
\itemize{
\item \code{summary}: a \code{data.frame} with columns matching
\code{method}, either \code{mean} or \code{median}; if \code{se.fit = TRUE}
the columns \code{sd}, \code{LB}, \code{UB} are included.
\item \code{plot}: a combined \code{ggplot} object with the fitted plots when an observed
\code{y} is available, otherwise \code{NULL}.
\item \code{rmse}: mean squared prediction error when \code{y} is available, otherwise \code{NULL}.
}
}
\description{
Computes posterior predictive summaries from a fitted single–index B-spline model
(class \code{bsimSpline}). Optionally returns a diagnostic plot and RMSE when
observed responses are provided.
}
\details{
The function first gathers posterior draws and computes predictive draws for each row of
\code{newdata} (or for the training data when \code{newdata = NULL}). From
these draws it forms.:
\itemize{
\item posterior mean and median,
\item empirical standard deviation (\code{sd}),
\item lower/upper quantiles for a \code{level} interval (\code{LB}, \code{UB}).
}
If \code{newdata} supplies a response column \code{y}, the function also
computes the mean squared prediction error (reported as \code{rmse}) and
creates two ggplot objects: (i) True vs Predicted with a 45° line and
(ii) Index value vs Response showing the fitted curve. If
\code{se.fit = TRUE}, a shaded area visualizes the \code{level} interval.

The index used in the fitted-curve plot is formed by projecting predictors
onto the estimated index vector extracted from \code{summary(object)}.
}
\seealso{
\code{\link{summary.bsimSpline}}
}
