% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_list.R
\name{plot.list}
\alias{plot.list}
\title{Plot a set of life tables}
\usage{
\method{plot}{list}(
  x,
  age = NULL,
  Ex = NULL,
  plotIC = TRUE,
  plotData = TRUE,
  labels = NULL,
  colors = NULL,
  linetype = NULL,
  prob = 0.95,
  ...
)
}
\arguments{
\item{x}{List of objects of the following classes: \code{HP}, \code{DLM}, \code{ClosedHP} or \code{ClosedDLM}.}

\item{age}{Vector with the ages to plot the life tables.}

\item{Ex}{Vector with the exposures of the selected ages. Its length must be equal to the age vector. This argument is only necessary when plotting poisson and binomial HP models.}

\item{plotIC}{Logical. If 'TRUE'(default), plots the predictive intervals.}

\item{plotData}{Logical. If 'TRUE' (default), plots the data used in the modelling as dots.}

\item{labels}{Description of the curve (Optional).}

\item{colors}{Vector of colours of the curves (Optional).}

\item{linetype}{Vector with the line type of the curve. (Optional).}

\item{prob}{Coverage probability of the predictive intervals. Default is '0.95'.}

\item{...}{Other arguments.}
}
\value{
A 'ggplot' object with fitted life tables.
}
\description{
Function that returns a log-scale 'ggplot' of the mortality graduation
returned by hp(), dlm(), hp_close() or dlm_close() functions.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the log mortality rate of the 1990 male population ranging from 0 to 100 years old
USA1990 = USA[USA$Year == 1990,]
x = 0:90
Ex = USA1990$Ex.Male[x+1]
Dx = USA1990$Dx.Male[x+1]
y = log(Dx/Ex)


## Fit poisson and lognormal HP model and DLM
fit = hp(x = x, Ex = Ex, Dx = Dx, model = "poisson",
         M = 2000, bn = 1000, thin = 1)
fit2 = dlm(y, M = 100)

## Plot multiples life tables
plot(list(fit, fit2),
     age = 0:110, Ex = USA1990$Ex.Male,
     plotIC = FALSE, colors = c("red", "blue"),
     labels = c("HP Poisson", "DLM"))


## Plot ClosedHP and ClosedDLM objects
close1 = hp_close(fit, method = "hp", x0 = 90)
close2 = dlm_close(fit2, method = "plateau")
plot(list(fit, fit2, close1, close2),
     plotIC = FALSE, colors = c("red", "blue", "green", "purple"),
     labels = c("HP", "DLM", "ClosedHP", "ClosedDLM"))

}
\seealso{
\code{\link[=plot.DLM]{plot.DLM()}}, \code{\link[=plot.HP]{plot.HP()}}, \code{\link[=plot.BLC]{plot.BLC()}} and \code{\link[=plot.PredBLC]{plot.PredBLC()}} for single plots.
}
