% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_hp.R
\name{summary.HP}
\alias{summary.HP}
\title{Summary for HP fitted models}
\usage{
\method{summary}{HP}(object, ...)
}
\arguments{
\item{object}{A \code{HP} or \code{ClosedHP} object, result of a call to hp() or hp_close() function.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame object with the mean, standard deviation and 2.5\%, 50\% and 97.5\% quantiles of a fitted \code{HP} or \code{ClosedHP} model.
}
\description{
Summarizes information from the parameters' markov chains of a fitted \code{HP} or \code{ClosedHP} model.
}
\examples{
 ## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the exposure and death count of the 2010 male population ranging from 0 to 90 years old
USA2010 = USA[USA$Year == 2010,]
x = 0:90
Ex = USA2010$Ex.Male[x+1]
Dx = USA2010$Dx.Male[x+1]

## Fitting binomial model
fit = hp(x = x, Ex = Ex, Dx = Dx, M = 5000, bn = 0, thin = 10)
summary(fit)

}
\seealso{
\code{\link[=summary.DLM]{summary.DLM()}} for \code{DLM} method.
}
