% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectancy_hp.R
\name{expectancy.HP}
\alias{expectancy.HP}
\title{HP Model: Life expectancy}
\usage{
\method{expectancy}{HP}(
  x,
  Ex = NULL,
  age = NULL,
  graph = TRUE,
  max_age = 110,
  prob = 0.95,
  ...
)
}
\arguments{
\item{x}{Object of the class \code{HP} or \code{ClosedHP} fitted by hp() or hp_close() functions.}

\item{Ex}{Numeric vector with the exposure by age. This argument is only necessary when using poisson and binomial models with objects of the class \code{HP}.}

\item{age}{Numeric vector specifying the ages to calculate the life expectancy. The default is a sequence (0, 10, 20, ...) until the last decade used in the fitted model.}

\item{graph}{Logical value (TRUE ou FALSE). If TRUE, it returns a plot.}

\item{max_age}{Positive number indicating the last age to be considered to compute the life expectancy (extrapolation will be considered to match the age interval if needed). This argument is only necessary with objects of the class \code{HP}.}

\item{prob}{A percentage specifying the probability of credible interval.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame and (if graph = TRUE) a plot.
}
\description{
This function computes the life expectancy for each age for Heligman-Pollard model.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

# Example 1: --------------------------------

USA1990 = USA[USA$Year == 1990,]

Ex = USA1990$Ex.Total[1:91]
Dx = USA1990$Dx.Total[1:91]
x = 0:90

fit <- hp(x, Ex, Dx, model = "binomial", M = 1000, bn = 0, thin = 10)
expectancy(fit)


# Example 2: -------------------------------

# Using some arguments:

Ex = USA1990$Ex.Total[1:106]

expectancy(fit, Ex = Ex, age = c(0,20,30,60,105),
max_age = 105, prob = 0.99, graph = FALSE)


}
\seealso{
\code{\link[=expectancy.DLM]{expectancy.DLM()}} and \code{\link[=expectancy.BLC]{expectancy.BLC()}} for \code{DLM} and \code{BLC}  methods.

\code{\link[=Heatmap.HP]{Heatmap.HP()}} and \code{\link[=Heatmap.list]{Heatmap.list()}} for \code{HP} or \code{list} methods to drawing a Heatmap for the truncated life expectancy.
}
