% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_observation_frequency.R
\name{compute_observation_frequency}
\alias{compute_observation_frequency}
\title{Frequency distribution of the ranking sequences}
\usage{
compute_observation_frequency(rankings)
}
\arguments{
\item{rankings}{A matrix with the individual rankings in each row.}
}
\value{
Numeric matrix with the distinct rankings in each row and the
corresponding frequencies indicated in the last \code{(n_items+1)}-th
column.
}
\description{
Construct the frequency distribution of the distinct ranking
sequences from the dataset of the individual rankings. This can be of
interest in itself, but also used to speed up computation by providing
the \code{observation_frequency} argument to \code{\link[=compute_mallows]{compute_mallows()}}.
}
\examples{
# Create example data. We set the burn-in and thinning very low
# for the sampling to go fast
data0 <- sample_mallows(rho0 = 1:5, alpha = 10, n_samples = 1000,
                        burnin = 10, thinning = 1)
# Find the frequency distribution
compute_observation_frequency(rankings = data0)

# The function also works when the data have missing values
rankings <- matrix(c(1, 2, 3, 4,
                     1, 2, 4, NA,
                     1, 2, 4, NA,
                     3, 2, 1, 4,
                     NA, NA, 2, 1,
                     NA, NA, 2, 1,
                     NA, NA, 2, 1,
                     2, NA, 1, NA), ncol = 4, byrow = TRUE)

compute_observation_frequency(rankings)
}
\seealso{
Other rank functions: 
\code{\link{compute_expected_distance}()},
\code{\link{compute_rank_distance}()},
\code{\link{create_ranking}()},
\code{\link{get_mallows_loglik}()},
\code{\link{sample_mallows}()}
}
\concept{rank functions}
