% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_consensus.R
\name{compute_consensus}
\alias{compute_consensus}
\title{Compute Consensus Ranking}
\usage{
compute_consensus(model_fit, type = "CP", burnin = model_fit$burnin)
}
\arguments{
\item{model_fit}{An object returned from \code{\link{compute_mallows}}.}

\item{type}{Character string specifying which consensus to compute. Either
\code{"CP"} or \code{"MAP"}. Defaults to \code{"CP"}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{model_fit$burnin}, and must be
provided if \code{model_fit$burnin} does not exist. See \code{\link{assess_convergence}}.}
}
\description{
Compute the consensus ranking using either cumulative probability (CP) or maximum a posteriori (MAP) consensus
\insertCite{vitelli2018}{BayesMallows}. For mixture models, the
consensus is given for each mixture.
}
\examples{
# The example datasets potato_visual and potato_weighing contain complete
# rankings of 20 items, by 12 assessors. We first analyse these using the Mallows
# model:
model_fit <- compute_mallows(potato_visual)

# Se the documentation to compute_mallows for how to assess the convergence of the algorithm
# Having chosen burin = 1000, we compute posterior intervals
model_fit$burnin <- 1000
# We then compute the CP consensus.
compute_consensus(model_fit, type = "CP")
# And we compute the MAP consensus
compute_consensus(model_fit, type = "MAP")

\dontrun{
  # CLUSTERWISE CONSENSUS
  # We can run a mixture of Mallows models, using the n_clusters argument
  # We use the sushi example data. See the documentation of compute_mallows for a more elaborate
  # example
  model_fit <- compute_mallows(sushi_rankings, n_clusters = 5)
  # Keeping the burnin at 1000, we can compute the consensus ranking per cluster
  model_fit$burnin <- 1000
  cp_consensus_df <- compute_consensus(model_fit, type = "CP")
  # Using dplyr::select and tidyr::cumprob we can now make a table
  # which shows the ranking in each cluster:
  library(dplyr)
  library(tidyr)
  cp_consensus_df \%>\%
    select(-cumprob) \%>\%
    spread(key = cluster, value = item)
}

\dontrun{
  # MAP CONSENSUS FOR PAIRWISE PREFENCE DATA
  # We use the example dataset with beach preferences.
  model_fit <- compute_mallows(preferences = beach_preferences)
  # We set burnin = 1000
  model_fit$burnin <- 1000
  # We now compute the MAP consensus
  map_consensus_df <- compute_consensus(model_fit, type = "MAP")
}
}
\references{
\insertAllCited{}
}
