% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode-finding.R
\name{opt.RMSProp}
\alias{opt.RMSProp}
\title{RMSProp optimiser}
\usage{
opt.RMSProp(eta = 0.001, rho = 0.9, eps = 1e-08)
}
\arguments{
\item{eta}{learning rate}

\item{rho}{momentum}

\item{eps}{not documented by Flux}
}
\value{
see \code{\link{opt.Descent}}
}
\description{
RMSProp optimiser
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  find_mode(bnn, opt.RMSProp(), 10, 100)
}

}
