% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_updates.R
\name{.lambda_MH_cp}
\alias{.lambda_MH_cp}
\title{Lambda MH step, proposal from conditional conjugate posterior}
\usage{
.lambda_MH_cp(
  df_hist,
  df_curr,
  Y,
  I,
  X,
  s,
  beta,
  beta_0 = NULL,
  mu,
  sigma2,
  lambda,
  lambda_0,
  tau,
  bp,
  bp_0 = 0,
  J,
  a_lam = 0.01,
  b_lam = 0.01,
  lambda_move = 0,
  lambda_count = 0,
  alpha = 0.3
)
}
\arguments{
\item{df_hist}{data.frame from dataframe_fun()}

\item{df_curr}{data.frame from dataframe_fun()}

\item{Y}{data}

\item{I}{censoring indicator}

\item{X}{design matrix}

\item{s}{split point locations, J + 2}

\item{beta}{parameter value for covariates}

\item{beta_0}{parameter value for historical covariates}

\item{mu}{prior mean for baseline hazard}

\item{sigma2}{prior variance hyperparameter for baseline hazard}

\item{lambda}{baseline hazard}

\item{lambda_0}{historical baseline hazard}

\item{tau}{borrowing parameter}

\item{bp}{number of covariates, length(beta)}

\item{bp_0}{number of covariates, length(beta_0)}

\item{J}{number of split points}

\item{a_lam}{lambda hyperparameter}

\item{b_lam}{lambda hyperparameter}

\item{lambda_move}{number of accepted lambda moves}

\item{lambda_count}{total number of lambda moves}

\item{alpha}{power parameter}
}
\value{
list of updated (if accepted) lambda and data.frames, as well as the 
number of accepted moves
}
\description{
Lambda MH step, proposal from conditional conjugate posterior
}
