% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_prior.R
\name{export_prior}
\alias{export_prior}
\title{Export prior}
\usage{
export_prior(x, out_fname = NULL, var_method = c("non-negative", "unbiased"))
}
\arguments{
\item{x}{The result of \code{estimate_prior}}

\item{out_fname}{Use \code{NULL} (default) to just return the prior
objects directly. Otherwise, use a character vector of length 3 or 4 of file
path(s) to save the output to:
the mean prior, the variance prior, the variance decomposition, and
the FC prior if present, in that order. If one file name is provided,
it will be appended with
\code{"_mean.[file_ext]"} for the prior mean map,
\code{"_var.[file_ext]"} for the prior variance map,
\code{"_varDecomp.rds"} for the variance decomposition, and
\code{"_FC.rds"} where \code{[file_ext]}
will be \code{"dscalar.nii"} for CIFTI input, \code{"nii"} for NIFTI input,
and \code{"rds"} for data input.}

\item{var_method}{\code{"non-negative"} (default) or \code{"unbiased"}}
}
\value{
If \code{is.null(out_fname)}, the priors in data matrix,
\code{"xifti"}, or \code{"nifti"} format, to match the format of the
original BOLD data. Otherwise, the paths to the new files specified by
\code{out_fname}. If prior includes functional connectivity components,
the FC prior and its mean and variance will be included.
}
\description{
Export the priors (mean, variance, and FC) as separate files for
visualization or processing outside of \code{BayesBrainMap}.
}
\examples{
\dontrun{
 tm <- estimate_prior(cii1_fnames, cii2_fnames, gICA_fname, usePar=FALSE)
 export_prior(tm, out_fname="my_prior", var_method="unbiased")
}

}
