% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.Bayenet.R
\name{predict.Bayenet}
\alias{predict.Bayenet}
\title{make predictions from a Bayenet object}
\usage{
\method{predict}{Bayenet}(object, X.new, clin.new, Y.new, ...)
}
\arguments{
\item{object}{Bayenet object.}

\item{X.new}{a matrix of new values for X at which predictions are to be made.}

\item{clin.new}{a vector or matrix of new values for clin at which predictions are to be made.}

\item{Y.new}{a vector of the response of new observations. If provided, the prediction error will be computed based on Y.new.}

\item{...}{other predict arguments}
}
\value{
an object of class `Bayenet.pred' is returned, which is a list with components:
\item{error}{prediction error. error is NULL is Y.new=NULL.}
\item{y.pred}{predicted values of the new observations.}
}
\description{
make predictions from a Bayenet object
}
\details{
X.new must have the same number of columns as X used for fitting the model. If clin was provided when fit the model, clin.new
must not be NULL, and vice versa. The predictions are made based on the posterior estimates of coefficients in the Bayenet object.
Note that the effects of clinical factors are not subject to selection.

If Y.new is provided, the prediction error will be computed. For robust methods, the prediction mean absolute deviations (PMAD) will be computed.
For non-robust methods, the prediction mean squared error (PMSE) will be computed.
}
\examples{
data(dat)
test=sample((1:nrow(X)), floor(nrow(X)/5))
fit=Bayenet(X[-test,], Y[-test], clin[-test,], max.steps=500,penalty="lasso")
predict(fit, X[test,], clin[test,], Y[test,])

}
\seealso{
\code{\link{Bayenet}}
}
