\name{CPPplotHR}
\alias{CPPplotHR}
\title{Function to Plot CPP Hazard Rates}
\description{A function to plot a (prior or posterior) sample of CPP hazard rates.}
\usage{CPPplotHR(sample = CPPpriorSample(0), npts = 101, tu = "Time Unit")}
\arguments{
  \item{sample}{sample of CPP hazard rates (as generated by \code{\link{CPPpriorSample}} or \code{\link{CPPpostSample}})}
  \item{npts}{number of time points where the hazard rates in the sample should be evaluated}
  \item{tu}{name of the time unit to be used for labelling the time axis}
}
\details{
For a prior sample, the individual trajectories are plotted (as solid lines)
and dashed lines are added to represent the pointwise prior mean and +/- one standard deviation band.

For a posterior sample, the pointwise posterior mean and equal tail 95\% credible band are drawn (as solid lines)
and dashed lines are added to represent the analogous posterior summaries for the constant hazard rate model
(using a conjugate gamma prior and letting its shape and rate parameters tend to zero). Furthermore,
the observations are marked on the time axis ("x" for exact observations, "o" for censored observations).

The range spanned by the time axis always goes from the origin to \code{sample$hyp$T00}.}
\value{Always \code{NULL}.}
\seealso{\code{\link{BayHaz-package}}, \code{\link{CPPevalHR}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a CPP prior distribution
hypars<-CPPpriorElicit(r0 = 0.1, H = 1, T00 = 50, M00 = 2)
# generate a sample of ten hazard rates
prior<-CPPpriorSample(ss = 10, hyp = hypars)

# plot the ten hazard rates
CPPplotHR(prior, tu = "Year")

# load a data set
data(earthquakes)
# generate a posterior sample
post<-CPPpostSample(hypars, times = earthquakes$ti, obs = earthquakes$ob)

# plot some posterior hazard rate summaries
CPPplotHR(post, tu = "Year")
}
\keyword{hplot}
\keyword{survival}
