\name{submitJobs}
\alias{submitJobs}
\title{Submit jobs or chunks of jobs to batch system via cluster function.}
\usage{
  submitJobs(reg, ids, resources = list(), wait,
    max.retries = 10L, job.delay = FALSE)
}
\arguments{
  \item{reg}{[\code{\link{Registry}}]\cr Registry.}

  \item{ids}{[\code{integer}]\cr Vector for job id or list
  of vectors of chunked job ids.  Only corresponding jobs
  are submitted. Chunked jobs will get executed
  sequentially as a single job for the scheduler.  Default
  is all jobs which were not yet submitted to the batch
  system.}

  \item{resources}{[\code{list}]\cr Required resources for
  all batch jobs. The elements of this list (e.g. something
  like \dQuote{walltime} or \dQuote{nodes} are defined by
  your template job file.  Defaults can be specified in
  your config file.  Default is empty list.}

  \item{wait}{[\code{function(retries)}]\cr Function that
  defines how many seconds should be waited in case of a
  temporary error.  Default is exponential back-off with
  \code{10*2^retries}.}

  \item{max.retries}{[\code{integer(1)}]\cr Number of times
  to submit one job again in case of a temporary error
  (like filled queues). Each time \code{wait} is called to
  wait a certain number of seconds.  Default is 10 times.}

  \item{job.delay}{[\code{function(n, i)} or
  \code{logical(1)}]\cr Function that defines how many
  seconds a job should be delayed before it starts.  This
  is an expert option and only necessary to change when you
  want submit extremely many jobs. We then delay the jobs a
  bit to write the submit messages as early as possible to
  avoid writer starvation.  \code{n} is the number of jobs
  and \code{i} the number of the ith job.  The default
  function used with \code{job.delay} set to \code{TRUE} is
  no delay for 100 jobs or less and otherwise
  \code{runif(1, 0.1*n, 0.2*n)}.  If set to \code{FALSE}
  (the default) delaying jobs is disabled.}
}
\value{
  Vector of submitted job ids.
}
\description{
  If the internal submit cluster function completes
  successfully, the \code{retries} counter is set back to 0
  and the next job or chunk is submitted. If the internal
  submit cluster function returns a fatal error, the submit
  process is completely stopped and an exception is thrown.
  If the internal submit cluster function returns a
  temporary error, the submit process waits for a certain
  time, which is determined by calling the user-defined
  \code{wait}-function with the current \code{retries}
  counter, the counter is increased by 1 and the same job
  is submitted again. If \code{max.retries} is reached the
  function simply terminates.
}
\examples{
reg <- makeRegistry(id="BatchJobsExample", file.dir=tempfile(), seed=123)
f <- function(x) x^2
batchMap(reg, f, 1:10)
submitJobs(reg)

# Submit the 10 jobs again, now randomized into 2 chunks:
chunked = chunk(getJobIds(reg), n.chunks=2, shuffle=TRUE)
submitJobs(reg, chunked)
}

