% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{Organism-constructor}
\alias{Organism-constructor}
\alias{Organism}
\title{Constructor of the S4 class \code{\link{Organism-class}}}
\usage{
Organism(model, algo = "fba", ex = "EX_", ex_comp = NA,
  csuffix = "\\\\[c\\\\]", esuffix = "\\\\[e\\\\]", lyse = FALSE,
  feat = list(), typename = NA, setExInf = TRUE, ...)
}
\arguments{
\item{model}{Object of class sybil::modelorg containging the genome sclae metabolic model}

\item{algo}{A single character string giving the name of the algorithm to use. See \link[sybil]{SYBIL_SETTINGS}}

\item{ex}{Identifier for exchange reactions}

\item{ex_comp}{ex_comp}

\item{csuffix}{csuffix}

\item{esuffix}{esuffix}

\item{lyse}{A boolean variable indicating if the organism should lyse after death.}

\item{feat}{A list containing conditional features for the object (contains at the momement only biomass components for lysis).}

\item{typename}{A string defining the name (set to model name in default case)}

\item{setExInf}{Enable if all lower bounds of exchange reaction which are set to zero (i.e. no uptake possible!) should be set to -infitity}

\item{...}{Arguments of \code{\link{Organism-class}}}
}
\value{
Object of class Organism
}
\description{
Constructor of the S4 class \code{\link{Organism-class}}
}
