% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_influence.R
\name{get_influence}
\alias{get_influence}
\title{Given a \code{model} object, rank the input predictors (and combinations thereof)
by thier influence on the output}
\usage{
get_influence(m, d, method = "sub", interactions = TRUE)
}
\arguments{
\item{m}{\code{Tucker_model} or \code{CP_model} object}

\item{d}{\code{input_data} object}

\item{method}{string 'sub' or 'add' indicating whether to start with a full or empty 
feature vector and remove or add features to judge their influence.}

\item{interactions}{logical indicating whether to get influence for two-way interactions 
between predictors (def: sub)}
}
\description{
If \code{method} is \code{'add'} then the baseline prediction is made using just the
constant coefficients (if used) and the mean squared error (MSE) is measured between 
the baseline and predictions made with each predictor added alone (univariate analysis).
}
\details{
If \code{method} is \code{'sub'} then the baseline is made using all predictors and
MSE measured for predictions made with each predictor removed.

If \code{interactions==TRUE} then MSE for predictions made with predictors for each mode
interacting are measured
}

