% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\title{Bayesian estimation}
\usage{
estimate(model.class, t, data, nMCMC, propSd, adapt = TRUE,
  proposal = c("normal", "lognormal"), ...)
}
\arguments{
\item{model.class}{class object with model informations, see \code{\link{set.to.class}}}

\item{t}{vector or list of time points}

\item{data}{vector or list or matrix of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}

\item{...}{parameters dependent on the model class}
}
\value{
class object \code{est.}\code{model.class} containing Markov chains, data input and model informations
}
\description{
Estimation method for the S4 classes.
}
\references{
Hermann, S. (2016). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Robert, C. P. and G. Casella (2004). Monte Carlo Statistical Methods. Springer, New York.

Rosenthal, J. S. (2011). Optimal Proposal Distributions and Adaptive MCMC. In: Handbook of Markov Chain Monte Carlo, pp. 93-112.
}

