% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/91_plot.R, R/deprecated.R
\name{plot.bvar}
\alias{plot.bvar}
\alias{bv_plot}
\title{Plotting method for Bayesian VARs}
\usage{
\method{plot}{bvar}(
  x,
  type = c("full", "trace", "density", "irf", "fcast"),
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  chains = list(),
  mar = c(2, 2, 2, 0.5),
  ...
)

bv_plot(x, mar = c(2, 2, 2, 0.5), ...)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{type}{A string with the type of plot desired. The standard method
\code{"full"} includes both density and trace plots.}

\item{vars}{Optional character vector used to subset the plot. The elements
need to match the names of hyperparameters (plus \code{"ml"}). Defaults
to \code{NULL}, i.e. all hyperparameters.}

\item{vars_response, vars_impulse}{Optional integer vector with the
positions of coefficient values used to subset the plot.
\emph{vars_response} corresponds to a specific dependent variable,
\emph{vars_impulse} to an independent one. Note that the constant is found
at position one.}

\item{chains}{List with additional \code{bvar} objects. Contents are then
added to trace and density plots.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns \emph{x} invisibly.
}
\description{
Method to plot trace and densities of hyperparameters and marginal likelihood
or coefficient values obtained from \code{\link{bvar}}. Plots may be subset
to certain types using \emph{type} and to hyperparameters using \emph{vars}.
Multiple chains, that is comparable \code{bvar} objects, may be plotted
together using the \emph{chains} argument.
The \emph{type} argument may be used to access \code{\link{plot.bvar_irf}}
and \code{\link{plot.bvar_fcast}}.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2, irf = bv_irf(), fcast = bv_fcast())
y <- bvar(data, lags = 2)

# Plot full traces and densities
plot(x)

# Compare with second chain
plot(x, chains = y)

# Only plot the marginal likelihood's density
plot(x, "dens", "ml")

# Use plot as an alternative to plot(irf(x)) and plot(predict(x))
plot(x, "irf")
plot(x, "fcast", vars = 2)
}
}
\seealso{
\code{\link{bvar}}; \code{\link{plot.bvar_fcast}};
\code{\link{plot.bvar_irf}}.
}
\keyword{BVAR}
\keyword{VAR}
\keyword{convergence}
\keyword{density}
\keyword{plot}
\keyword{trace}
