% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/50_fcast_setup.R, R/55_fcast_print.R
\name{bv_fcast}
\alias{bv_fcast}
\alias{print.bv_fcast}
\title{Forecast settings}
\usage{
bv_fcast(horizon = 12, conditional = FALSE)

\method{print}{bv_fcast}(x, ...)
}
\arguments{
\item{horizon}{Integer scalar. Horizon for which forecasts should be
computed.}

\item{conditional}{Logical scalar. Not yet implemented.}

\item{x}{Object of class \code{bv_fcast}.}

\item{...}{Not used.}
}
\value{
Returns a named list of class \code{bv_fcast} with options for
\code{\link{bvar}} or \code{\link{predict.bvar}}.
}
\description{
Provide forecast settings to \code{\link{bvar}} or
\code{\link{predict.bvar}}. Allows adjusting the horizon of the forecast.
}
\details{
As of now only unconditional forecasts are implemented and conditional must
be set to \code{FALSE}. Conditional forecasts will require further options,
such as variable paths.
}
\examples{
# Set the forecast-horizon to 20 time periods instead of 12
bv_fcast(horizon = 20)
}
\seealso{
\code{\link{bvar}}; \code{\link{predict.bvar}};
\code{\link{plot.bvar_fcast}}
}
\keyword{BVAR}
\keyword{VAR}
\keyword{forecasts}
\keyword{prediction}
\keyword{settings}
