% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootBTdecayLasso.R
\name{boot.BTdecayLasso}
\alias{boot.BTdecayLasso}
\title{Compute the standard deviation of Bradley-Terry decay Lasso model by bootstrapping}
\usage{
boot.BTdecayLasso(dataframe, ability, lambda, boot = 100, weight = NULL,
  decay.rate = 0, fixed = 1, thersh = 1e-05, max = 100, iter = 100)
}
\arguments{
\item{dataframe}{Generated using \code{\link{BTdataframe}} given raw data.}

\item{ability}{A column vector of teams ability, the last row is the home parameter.
The row number is consistent with the team's index shown in dataframe. It can be generated using \code{\link{BTdataframe}} given raw data.}

\item{lambda}{The amount of Lasso penalty induced, only a single scalar is accepted in bootstrapping.}

\item{boot}{Amount of simulations.}

\item{weight}{Weight for Lasso penalty on different abilities.}

\item{decay.rate}{The exponential decay rate. Usually ranging from (0, 0.01), A larger decay rate weights more
importance to most recent matches and the estimated parameters reflect more on recent behaviour.}

\item{fixed}{A teams index whose ability will be fixed as 0. The worstTeam's index
can be generated using \code{\link{BTdataframe}} given raw data.}

\item{thersh}{Threshold for convergence}

\item{max}{Maximum weight for \eqn{w_{ij}} (weight used for Adaptive Lasso).}

\item{iter}{Number of iterations used in L-BFGS-B algorithm.}
}
\value{
A list with class "boot" contain Lasso and Hybrid Lasso's bootstrapping's mean and standard deviation.
\item{Lasso}{Lasso bootstrapping's result. A three column matrix where first column is the original estimation, the second column is bootstrapping mean and the last column is the
bootstrapping standard deviation}
\item{HYBRID.Lasso}{HYBRID Lasso bootstrapping's result. A three column matrix where the first column is the original estimation, the second column is bootstrapping mean and the last column is the
bootstrapping standard deviation}
}
\description{
Bootstrapping is done assuming that Maximum Likelihood's estimation reflects the true abilities.
Same level of Lasso penalty "lambda" should be applied in different simulation models for Lasso induced estimation.
}
\details{
100 times of simulation will be done by default, user can adjust the numbers of simulation by input of boot. However, bootstrapping process
is time consuming and usually 1000 time of simulations is enough to provide a stable result.

More detailed description of "lambda", "penalty" and "weight" are documented in \code{\link{BTdecayLasso}}.

summary() function follows S3 method can be applied to view the outputs.
}
\examples{
##Initialize the dataframe and ability
x <- BTdataframe(NFL2010)

##The following code runs the main results
\donttest{
##Run Lasso estimate for whole Lasso path
z <- BTdecayLasso(x$dataframe, x$ability, fixed = x$worstTeam)

##Model selection using AIC with Lasso's likelihood
z1 <- BTdecayLassoC(x$dataframe, x$ability, model = z, 
                    criteria = "AIC", type = "LASSO", fixed = x$worstTeam)

##Bootstrapping for model with lowest AIC score for 100 times.
##Note that the decay.rate used in model selection should be consistent with
##the one which is used in whole Lasso path's run (keep the same model)
z2 <- boot.BTdecayLasso(x$dataframe, x$ability, lambda = z1$Optimal.lambda, 
                        boot = 100, fixed = x$worstTeam)
}

}
\references{
Masarotto, G. and Varin, C.(2012) The Ranking Lasso and its Application to Sport Tournaments. 
*The Annals of Applied Statistics* **6** 1949--1970.

Zou, H. (2006) The adaptive lasso and its oracle properties. 
*J.Amer.Statist.Assoc* **101** 1418--1429.
}
\seealso{
\code{\link{BTdataframe}} for dataframe initialization, \code{\link{BTdecayLasso}} for detailed description
}
