% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_class.R
\name{plot}
\alias{plot}
\alias{combinePlotsBSL}
\alias{plot.bsl}
\alias{plot.penbsl}
\title{Plotting BSL and BSLasso Results}
\usage{
combinePlotsBSL(..., true_value = NULL, thin = 1)

\method{plot}{bsl}(x, true_value = NULL, thin = 1, ...)

\method{plot}{penbsl}(x, logscale = TRUE, ...)
}
\arguments{
\item{...}{The first inputs to the \code{combinePlotsBSL} function should be two or more results of type \code{bsl}, separated by commas.}

\item{true_value}{A set of values to be included on the plots as a reference line. The default is \code{NULL}.}

\item{thin}{The gap between samples to be taken when thinning the MCMC draws. The default is 1 (no thinning).}

\item{x}{An object to be plotted.}

\item{logscale}{An indicator for whether the penalty values should be shown on the log scale in plots of \code{penbsl} objects. The default is \code{TRUE}.}
}
\description{
There are several functions included in this package to help visualise the results of the MCMC run and of the tuning process.

The function \code{combinePlotsBSL} can be used to plot multiple BSL and BSLasso densities together, optionally with the true values for the parameters.

The function \code{plot.BSL} can be used to plot BSL and BSLasso densities, optionally with the true values for the parameters.

The function \code{plot.penbsl} can be used to plot the results from tuning to select the optimal penalty for BSLasso.
}
\author{
Ziwen An, Christopher C. Drovandi and Leah F. South
}
