% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Airline}
\alias{Airline}
\title{Percentage of on-time arrivals and number of complaints for 11 airlines}
\format{
A data frame/tibble with 11 observations on three variables
\describe{ 
\item{airline}{a charater variable with values \code{Alaska},
\code{Amer West}, \code{American}, \code{Continental}, \code{Delta},
\code{Northwest}, \code{Pan Am}, \code{Southwest}, \code{TWA}, 
\code{United}, and \code{USAir}} 
\item{ontime}{a numeric vector}
\item{complaints}{complaints per 1000 passengers} 
}
}
\source{
Transportation Department.
}
\usage{
Airline
}
\description{
Data for Example 2.9
}
\examples{

with(data = Airline, 
     barplot(complaints, names.arg = airline, col = "lightblue", 
     las = 2)
)
plot(complaints ~ ontime, data = Airline, pch = 19, col = "red",
     xlab = "On time", ylab = "Complaints")

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
