% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Wins}
\alias{Wins}
\title{Baseball team wins versus seven independent variables for National league teams
in 1990}
\format{A data frame with 12 observations on nine variables
\describe{ 
\item{team}{name of team}
\item{wins}{number of wins} 
\item{batavg}{batting average} 
\item{rbi}{runs batted in} 
\item{stole}{bases stole} 
\item{strkout}{number of strikeots} 
\item{caught}{number of times caught stealing} 
\item{errors}{number of errors} 
\item{era}{earned run average} 
}}
\usage{
Wins
}
\description{
Data for Exercise 9.23
}
\examples{

plot(wins ~ era, data = Wins)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Wins, aes(x = era, y = wins)) + 
           geom_point() + 
           geom_smooth(method = "lm", se = FALSE) + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
