\name{BRugsFit}
\alias{BRugsFit}
\title{BRugs' meta function}
\description{This function takes model, data and starting values as input and automatically runs a simulation in BRugs.}
\usage{
BRugsFit(modelFile, data, inits, numChains = 3, parametersToSave,
    nBurnin = 1000, nIter = 1000, nThin = 1, coda = FALSE,
    DIC = TRUE, working.directory = NULL, digits = 5, seed=NULL,
    BRugsVerbose = getOption("BRugsVerbose"))
}
\arguments{
\item{modelFile}{File containing the model written in OpenBUGS code,
    an R function that contains a BUGS model that is written to a temporary model file (see \code{\link{tempfile}}) using \code{\link{writeModel}}.}
\item{data}{Either a named list (names corresponding to variable names in the \code{modelFile})
    of the data for the OpenBUGS model, \emph{or}
    a vector or list of the names of the data objects used by the model.
    In these cases data are written into a file \file{data.txt} into the temporary directory of the current R session.

    If a filename of an existing file is given, data are read from that file.}
\item{inits}{A list with \code{numChains} elements; each element of the list is
    itself a list of starting values for the OpenBUGS model, \emph{or}
    a function creating (possibly random) initial values.
    In these cases inits are written into files \file{inits1.txt}, \dots, \file{initsN.txt} into the temporary directory of the current R session.

    If a vector of filenames of existing files is given, inits are read from those files.
    Alternatively, if \code{inits} is not specified, initial values are generated by OpenBUGS.}
\item{numChains}{Number of Markov chains (default: 3).}
\item{parametersToSave}{Character vector of the names of the parameters to save which should be monitored.}
\item{nBurnin}{Length of burn in (before \code{nIter} iterations start).}
\item{nIter}{Number of iterations (without burn in).}
\item{nThin}{Every \code{nThin}-th iteration of each chain is stored.}
\item{coda}{Determines the output format: if \code{FALSE} (default), a list containing sample and DIC statistics is returned.
    If \code{TRUE}, an \code{\link[coda]{mcmc.list}} object as known from the \pkg{coda} package is returned.}
\item{DIC}{Logical, whether to calculate and return the DIC.}
\item{working.directory}{Sets working directory during execution of this function;
    \code{data}, \code{inits} and other files are written to / read from this directory if no other directory
    is explicitly given in those arguments.
    If \code{NULL}, the current working directory is chosen.}
\item{digits}{Number of significant digits used for OpenBUGS input, see \code{\link{formatC}}.}
\item{seed}{Integer value from 1 to 14 defining the state of the random number
  generator - default is to not specify the state (see \code{\link{modelSetRN}}).}
\item{BRugsVerbose}{Logical, whether BRugs is supposed to be verbose.
    This can be controlled for the whole BRugs package by by the option \sQuote{BRugsVerbose} (see \code{\link{options}})
    which is set to \code{TRUE} by default.}
}
\value{If \code{coda} is set to \kbd{TRUE}, an \code{\link[coda]{mcmc.list}} object as known from the \pkg{coda} package is returned,
otherwise a list containg components
\item{Stats}{A data frame containing sample statistics. See \code{\link{samplesStats}}.}
\item{DIC}{The DIC statistics, if \code{DIC=TRUE}, else \code{NULL}. See \code{\link{dicStats}}.}
}
\seealso{\code{\link{BRugs}}, \code{\link{help.WinBUGS}}.
    Andrew Gelman proposes some \code{print} and \code{plot} methods that can be accessed by the
    \code{openbugs} (and \code{bugs}) and \code{as.bugs.array} functions in the CRAN package \pkg{R2WinBUGS}.}
\examples{
\donttest{
## Prepare the example files in a temporary directory
exfiles <- dir(options()$OpenBUGSExamples, pattern="^Rats.*txt$", full.names=TRUE)
ok <- file.copy(exfiles, tempdir())
BRugsFit(data = "Ratsdata.txt", inits = "Ratsinits.txt",
    para = c("alpha", "beta"), modelFile = "Ratsmodel.txt",
    numChains = 1,
    working.directory = tempdir())
}
}
\keyword{interface}
\concept{OpenBUGS}
\concept{WinBUGS}
\concept{MCMC}
