% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotBRBVS}
\alias{plotBRBVS}
\title{Plot Results of BRBVS Algorithm}
\usage{
plotBRBVS(object, ...)
}
\arguments{
\item{object}{An object containing the results of the BRBVS algorithm.
Expected to contain matrices \code{mtx.act1E} and \code{mtx.act2E} for feature names,
vectors \code{freq.rel1E} and \code{freq.rel2E} for relative frequencies, and
additional elements \code{Namecondings}, \code{metric}, \code{copula}, \code{margins} for feature decoding and plot annotations.}

\item{...}{Additional arguments to be passed to plotting functions.}
}
\value{
A ggplot object representing the BRBVS algorithm results.
Features are displayed on the x-axis and their relative frequencies on the y-axis.
The plot is split into two facets for each survival.
}
\description{
This function takes an object containing the results of the BRBVS algorithm
and plots the active features against their relative frequencies for the two time to events.
}
\examples{
############################
# Toy Example
############################
BRBVS_object <- list(
mtx.act1E = c("z2", "z1", "0", "0"),
scores1E = c(20, 1, 1),
freq.rel1E = c(1, 1, 1, 1),
mtx.act2E = c("z2", "z1", "0", "0"),
scores2E = c(20, 1, 1),
freq.rel2E = c(1, 1, 1, 1),
metric = "FIM",
kmax = 4,
copula = "C0",
margins = c("PO", "PO"),
tau = 0.5,
Namecondings = matrix(
 c("z1", "z1", "z2", "z2", "z3", "z3", "z4", "z4", "z5", "z5", "z6", "z6"),
 nrow = 6, ncol = 2, byrow = TRUE,
 dimnames = list(NULL, c("Features", "Code"))
)
)

class(BRBVS_object) <- "BRBVS"
plotBRBVS(BRBVS_object)

}
