% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{dBNPdens.BNPdens}
\alias{dBNPdens.BNPdens}
\title{Evaluate estimated univariate densities at a given point}
\usage{
\method{dBNPdens}{BNPdens}(object, x)
}
\arguments{
\item{object}{a \code{BNPdens} object (only if univariate);}

\item{x}{the point where to evaluate the density.}
}
\value{
a numeric value
}
\description{
The method \code{dBNPdens} provides an approximated evaluation of estimated univariate densities at a given point, for a \code{BNPdens} class object.
}
\examples{
data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
grid <- seq(-7, 7, length.out = 50)
est_model <- PYdensity(y = data_toy, mcmc = list(niter = 200, nburn = 100),
                       output = list(grid = grid))
x <- 1.4
dBNPdens(est_model, x)

}
