% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MAR}
\alias{MAR}
\title{C++ function to estimate Pitman-Yor univariate mixtures via marginal sampler}
\arguments{
\item{data}{a vector of observations}

\item{grid}{vector to evaluate the density}

\item{niter}{number of iterations}

\item{nburn}{number of burn-in iterations}

\item{m0}{expectation of location component}

\item{k0}{tuning parameter of variance of location component}

\item{a0}{parameter of scale component}

\item{b0}{parameter of scale component}

\item{mass}{mass of Dirichlet process}

\item{nupd}{number of iterations to show current updating}

\item{out_param}{if TRUE, return also the location and scale paramteres lists}

\item{out_dens}{if TRUE, return also the estimated density (default TRUE)}

\item{process}{if 0 DP, if 1 PY}

\item{sigma_PY}{second parameter of PY}

\item{print_message}{print the status}
}
\description{
C++ function to estimate Pitman-Yor univariate mixtures via marginal sampler
}
\examples{
{
  data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
  grid <- seq(-7, 7, length.out = 50)
  est_model <- MAR(data_toy, grid, 50, 10, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
  \dontshow{
    data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
    grid <- seq(-7, 7, length.out = 50)
    est_model <- MAR(data_toy, grid, 50, 10, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
  }
  \donttest{
    data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
    grid <- seq(-7, 7, length.out = 50)
    est_model <- MAR(data_toy, grid, 1000, 100, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
  }
}

}
