% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{full_request}
\alias{full_request}
\title{Create an API call, send the request and retrieve the results, and parse them}
\usage{
full_request(
  ...,
  get_params = list(),
  parse = TRUE,
  clean_dates = TRUE,
  rename = TRUE
)
}
\arguments{
\item{...}{values to be passed to appropriate build_x_call function}

\item{get_params}{list; parameters to be passed to the send_request function (which will pass those parameters to httr::get)}

\item{parse}{boolean; whether the results should be parsed or returned as a response() object}

\item{clean_dates}{boolean; whether the csv response columns should be cleaned (reformatted to be correct date/time/datetime)}

\item{rename}{boolean; whether blank columns should be renamed (not always accurate)}
}
\value{
If parse == TRUE, a tibble if service_type = "csv", otherwise a list. If parse == FALSE, a response() object is returned
}
\description{
Create an API call, send the request and retrieve the results, and parse them
}
\examples{
\donttest{
full_request(data_item = "B1730", api_key = "12345",
settlement_date = "14-12-2016", parse = TRUE, service_type = "xml")
}
}
