% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeKernelDensityEstimation.R
\encoding{UTF-8}
\name{imputeKernelDensityEstimation}
\alias{imputeKernelDensityEstimation}
\title{imputing BLOQ's using kernel density estimation}
\usage{
imputeKernelDensityEstimation(inputData, LOQ, epsilon = 1e-07,
  maxIter = 1000, useSeed = runif(1))
}
\arguments{
\item{inputData}{numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
 the input dataset}

\item{LOQ}{scalar, limit of quantification value}

\item{epsilon}{scalar with 1e-07 as default, the difference between two iterations 
which achieving it would stop the procedure (convergence).}

\item{maxIter}{scalar, the maximum number of iterations with 1000 as default.}

\item{useSeed}{scalar, set a seed to make the results 
reproducible, default is runif(1), it is used to randomly 
order the first imputed column (if the first column has any BLOQ's)}
}
\value{
the imputed dataset: a numeric matrix or data frame of the size 
n by J (n the sample size and J the number of time points)
}
\description{
function to impute BLOQ observations using kernel density 
estimation.
}
\examples{
# generate data from Beal model with only fixed effects
set.seed(111)
genDataFixedEffects <- simulateBealModelFixedEffects(10, 0.693,
		1, 1, seq(0.5,3,0.5))
imputeKernelDensityEstimation(genDataFixedEffects, 0.1, epsilon = 1e-05)
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
