% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_sf}
\alias{BIEN_ranges_sf}
\title{Download range maps that intersect a user-supplied sf object.}
\usage{
BIEN_ranges_sf(
  sf,
  directory = NULL,
  species.names.only = FALSE,
  return.species.list = TRUE,
  crop.ranges = FALSE,
  include.gid = FALSE,
  ...
)
}
\arguments{
\item{sf}{An object of class sf.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{species.names.only}{Return species names rather than spatial data? Default is FALSE.}

\item{return.species.list}{Should a species list be returned in addition to downloading range maps?  Default is FALSE}

\item{crop.ranges}{Should the ranges be cropped to the focal area? Default is FALSE.}

\item{include.gid}{Should the files returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
All range maps that intersect the user-supplied sf object.
}
\description{
BIEN_ranges_sf extracts range maps that intersect a specified simple features (sf) object.
}
\note{
Details on the construction of BIEN range maps is available at https://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\dontrun{

# Here we use a range map as our example polygon

BIEN_ranges_species("Carnegiea gigantea") #saves ranges to the current working directory

# Read in the polygon  with sf   
sf <- sf::st_read(dsn = ".",
                  layer = "Carnegiea_gigantea")

BIEN_ranges_sf(sf = sf,
               limit = 10) 
               # We use the limit argument to return only 10 range maps.
               # Omit the limit argument to get all ranges

#Note that this will save many shapefiles to the working directory.
}
}
\seealso{
Other range functions: 
\code{\link{BIEN_ranges_box}()},
\code{\link{BIEN_ranges_genus}()},
\code{\link{BIEN_ranges_intersect_species}()},
\code{\link{BIEN_ranges_list}()},
\code{\link{BIEN_ranges_load_species}()},
\code{\link{BIEN_ranges_shapefile_to_skinny}()},
\code{\link{BIEN_ranges_skinny_ranges_to_richness_raster}()},
\code{\link{BIEN_ranges_species_bulk}()},
\code{\link{BIEN_ranges_species}()}
}
\concept{range functions}
