% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_traitbygenus}
\alias{BIEN_trait_traitbygenus}
\title{Download trait data for given genus/genera and trait(s).}
\usage{
BIEN_trait_traitbygenus(trait, genus, print.query = FALSE, ...)
}
\arguments{
\item{trait}{A single trait or a vector of traits.}

\item{genus}{A single genus or a vector of genera.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A dataframe of all data matching the specified trait(s) and genus/genera.
}
\description{
BIEN_trait_traitbygenus extracts entries that contain the specified genus/genera and trait(s).
}
\examples{
\dontrun{
BIEN_trait_traitbygenus(trait = "Height", genus = "Carex")
trait_vector<-c("Height", "Leaf dry mass")
genus_vector<-c("Carex","Betula")
BIEN_trait_traitbygenus(trait=trait_vector,genus=genus_vector)}
}
\seealso{
Other trait functions: \code{\link{BIEN_trait_family}},
  \code{\link{BIEN_trait_list}},
  \code{\link{BIEN_trait_mean}},
  \code{\link{BIEN_trait_species}},
  \code{\link{BIEN_trait_traitbyfamily}},
  \code{\link{BIEN_trait_traitbyspecies}},
  \code{\link{BIEN_trait_traits_per_species}},
  \code{\link{BIEN_trait_trait}}
}

