% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGaMRes.R
\name{CGaMRes}
\alias{CGaMRes}
\title{Markov Gamma Model with Covariates}
\usage{
CGaMRes(
  data,
  type.t = 2,
  length = 1,
  K = 5,
  alpha = rep(0.01, K),
  beta = rep(0.01, K),
  c.r = rep(1, K - 1),
  c.nu = 1,
  var.theta.str = 25,
  var.theta.ini = 100,
  a.eps = 0.1,
  b.eps = 0.1,
  type.c = 4,
  epsilon = 1,
  iterations = 1000,
  burn.in = floor(iterations * 0.2),
  thinning = 3,
  printtime = TRUE
)
}
\arguments{
\item{data}{Double tibble. Contains failure times in the first column,
status indicator in the second, and, from the third to the last column, the
covariate(s).}

\item{type.t}{Integer. 1=computes uniformly-dense intervals; 2=length
intervals defined by user and 3=same length intervals.}

\item{length}{Integer. Interval length of the partition.}

\item{K}{Integer. Partition length for the hazard function.}

\item{alpha}{Nonnegative entry vector. Small entries are recommended in
order to specify a non-informative prior distribution.}

\item{beta}{Nonnegative entry vector. Small entries are recommended in order
to specify a non-informative prior distribution.}

\item{c.r}{Nonnegative vector. The higher the entries, the higher the correlation of 
two consecutive intervals.}

\item{c.nu}{Tuning parameter for the proposal distribution for c.}

\item{var.theta.str}{Double. Variance of the proposal normal distribution
for theta in the Metropolis-Hastings step.}

\item{var.theta.ini}{Double. Variance of the prior normal distribution for theta.}

\item{a.eps}{Double. Shape parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{b.eps}{Double. Scale parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{type.c}{1=defines \code{c.r} as a zero-entry vector; 2=lets the user
define \code{c.r} freely; 3=assigns \code{c.r} by computing an exponential
prior distribution with mean 1; 4=assigns \code{c.r} an exponential hierarchical
distribution with mean \code{epsilon} which in turn has a Ga(a.eps, b.eps)
distribution.}

\item{epsilon}{Double. Mean of the exponential distribution assigned to
\code{c.r} when \code{type.c = 3}.}

\item{iterations}{Integer. Number of iterations including the \code{burn.in}
to be computed for the Markov chain.}

\item{burn.in}{Integer. Length of the burn-in period for the Markov chain.}

\item{thinning}{Integer. Factor by which the chain will be thinned. Thinning
the Markov chain reduces autocorrelation.}

\item{printtime}{Logical. If \code{TRUE}, prints out the execution time.}
}
\description{
Posterior inference for the Bayesian non-parametric Markov gamma model with
covariates in survival analysis.
}
\details{
Computes the Gibbs sampler with the full conditional distributions of
Lambda and Theta (Nieto-Barajas, 2003) and arranges the resulting Markov
chain into a matrix which can be used to obtain posterior summaries. Prior
distributions for the re gression coefficients (Theta) are assumed independent normals
with zero mean and variance \code{var.theta.ini}.
}
\note{
It is recommended to verify chain's stationarity. This can be done by
checking each element individually. See \link{CGaPlotDiag}
To obtain posterior summaries of the coefficients use function
\link{CGaPloth}.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
#  data(leukemiaFZ)
#  leukemia1 <- leukemiaFZ
#  leukemia1$wbc <- log(leukemiaFZ$wbc)
#  CGEX1 <- CGaMRes(data = leukemia1, K = 10, iterations = 100, thinning = 1)

## Example 2. Refer to "Cox-gamma model example" section in package vignette for details.
# SampWeibull <- function(n, a = 10, b = 1, beta = c(1, 1)) {
#   M <- tibble(i = seq(n), x_i1 = runif(n), x_i2 = runif(n), 
#               t_i = rweibull(n, shape = b, 
#                                 scale = 1 / (a * exp(x_i1*beta[1] + x_i2*beta[2]))),
#               c_i = rexp(n), delta = t_i > c_i,
#               `min{c_i, d_i}` = min(t_i, c_i))
#   return(M)
# }
#  dat <- SampWeibull(100, 0.1, 1, c(1, 1))
#  dat <- dat \%>\% select(4,6,2,3) 
#  CG <- CGaMRes(data = leukemia1, K = 10, iterations = 100, thinning = 1)
#  CGaPloth(CG)



}
\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma
processes and time dependent covariates in survival analysis. \emph{Bulletin
of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and gamma
processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{CGaPlotDiag}, \link{CGaPloth}
}
