% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaPloth.R
\name{GaPloth}
\alias{GaPloth}
\title{Plots for the Hazard and Survival Function Estimates}
\usage{
GaPloth(M, type.h = "segment", addSurvival = T, confidence = 0.95,
  summary = FALSE)
}
\arguments{
\item{M}{tibble. Contains the output by \code{CGaMRres} and \code{GaMRes}.}

\item{type.h}{character. "segment"= use segments to plot hazard rates,
"line" = link hazard rates by a line}

\item{addSurvival}{Logical. If \code{TRUE}, Nelson-Aalen estimate is plotted
over the hazard function and Kaplan-Meier estimate is plotted over the
survival function.}

\item{confidence}{Numeric. Confidence level.}

\item{summary}{Logical. If \code{TRUE}, a summary for hazard and survival
functions is returned as a tibble.}
}
\value{
\item{SUM.h}{Numeric tibble. Summary for the mean, median, and a
\code{confint / 100} confidence interval for each segment of the hazard
function. If \code{summary = TRUE}} \item{SUM.S}{Numeric tibble. Summary for
the mean, median, and a \code{confint / 100} confidence interval for a grid
of the survival function. If \code{summary = TRUE}}
}
\description{
Plots the hazard function and with the survival function
estimates defined by the Markov gamma process with and without covariates
(Nieto-Barajas & Walker, 2002).
}
\details{
This function returns estimators plots for the resulting hazard rate as it is computed
by \link{GaMRes} and \link{CGaMRes} and the Nelson-Aalen
estimate along with their confidence intervals for the data set given.
Additionally, it plots the survival function and the Kaplan-Meier estimate
with their corresponding credible/confidence intervals.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
#  data(gehan)
#  timesG <- gehan$time[gehan$treat == "6-MP"]
#  deltaG <- gehan$cens[gehan$treat == "6-MP"]
#  GEX1 <- GaMRes(timesG, deltaG, K = 8, iterations = 3000)
#  GaPloth(GEX1)


## Example 2
#  data(leukemiaFZ)
#  timesFZ <- leukemiaFZ$time
#  deltaFZ <- leukemiaFZ$delta
#  GEX2 <- GaMRes(timesFZ, deltaFZ, type.c = 4)
#  GaPloth(GEX2)





}
\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma
processes and time dependent covariates in survival analysis. \emph{Bulletin
of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and gamma
processes for modelling hazard rates. \emph{Scandinavian Journal of
Statistics} \strong{29}: 413-424.
}
\seealso{
\link{GaMRes}, \link{CGaMRes}, \link{CGaPlotDiag},
\link{GaPlotDiag}
}
