% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate}
\alias{estimate}
\title{GGMs with Credible Intervals or the Region of Practical Equivalence}
\usage{
estimate(Y, iter = 5000, analytic = FALSE, ...)
}
\arguments{
\item{Y}{data matrix (\emph{n} by  \emph{p}).}

\item{iter}{number of posterior samples}

\item{analytic}{analytic solution. see notes for further details.}

\item{...}{not used}
}
\value{
list of class \code{estimate}:

\code{analytic = TRUE}:
\itemize{
\item \code{fit} list of analytic solution estimates
\itemize{
\item \code{inv_mu} inverse covariance matrix (mean)
\item \code{inv_var} inverse covariance matrix (variance)
\item \code{partial} partial correlation matrix
}
\item \code{analytic} TRUE
\item \code{call} match.call()
\item \code{dat} data matrix
\item \code{p} number of variables
}

\code{analytic = FALSE}:
\itemize{
\item \code{parcors_mat} partial correlation matrix
\item \code{inv_mat} inverse covariance matrix
\item \code{posterior samples} posterior samples for partial correlations and inverse covariance matrix
\item \code{p} number of variables
\item \code{dat} data matrix
\item \code{iter} number of posterior samples
\item \code{call} match.call()
\item \code{analytic} FALSE
}
}
\description{
Estimate the conditional (in)dependence structure with credible intervals or the region of practical equivalence.
For the former, there is an analytic solution available, whereas for the latter, samples are efficiently drawn from the posterior
distribution.
}
\note{
The default is to draws samples from the posterior distribution (\code{analytic = FALSE}). The samples are required for computing edge differences,
Bayesian R2, etc. If the goal is to *only* determined the non-zero effects, this can be accomplished by setting \code{analytic = TRUE}. This is accomplished
by estimating the posterior mean and variance, from which the credible intervals can computed. Note also sampling is very fast--i.e., less than 1 second
with p = 25, n = 2500 and 5,000 samples. There is one function that makes use of the analytic solution. Namely, \code{loocv} computes node-wise leave-one-out
error (also analytically).

see \code{methods("estimate")}
}
\examples{
# p = 20
Y <- BGGM::bfi[, 1:5]

# analytic approach (sample by setting analytic = FALSE)
fit_analytic <- estimate(Y, analytic = TRUE)

# select the graph (edge set E)
E <- select(fit_analytic, ci_width = 0.95)

}
