% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_beam_clin.R
\name{plot_beam_clin}
\alias{plot_beam_clin}
\title{Plot BEAM Sets}
\usage{
plot_beam_clin(
  beam.result,
  beam.specs = NULL,
  beam.set.pvals,
  beam.feat.pvals,
  set.id,
  gene.name = NULL,
  pair.type = NULL,
  number.pairs = 1,
  pair.order = "both",
  endpt.order = NULL,
  n.col = NULL,
  n.row = NULL,
  title.size = 10
)
}
\arguments{
\item{beam.result}{A beam.stats object from compute_beam_stats}

\item{beam.specs}{A data.frame. Default NULL, in which case beam.result$beam.specs is used. Otherwise can input other beam.specs data.frame that must contain name, mtx, mdl, plot columns.}

\item{beam.set.pvals}{A list containing BEAMR set p-values from compute_set_pvalues.}

\item{beam.feat.pvals}{A list containing feature-level p-values from compute_feature_pvalues.}

\item{set.id}{A character specifying the name of a set. Must be in beam.result$beam.data$set.data}

\item{gene.name}{A character specifying a Gene Name/Symbol for the set. Default is NULL}

\item{pair.type}{A character vector. Default NULL, in which case clinical plots for all omic/endpoint pairs are produced. Otherwise specify pairs from beam.stats$beam.specs$name}

\item{number.pairs}{A numeric. Default 1, in which case only feature with best simple test for each pair is plotted. If >1, show top n simple plots ordered by feature-level p-value}

\item{pair.order}{One of c("both", "omic", "endpoint"). Default is "both." Specify how to choose feature-endpoint plots to include. If "both", find the best (based on q, p, effect size) feature-omic pair for each type of omic and each endpoint separately. If "omic", within each omic, find the best feature-endpoint pair and then plot this feature with all endpoints. If "endpoint", need to specify endpt.order as the name of chosen endpoint. Then, within each omic, find the feature with best association with the selected endpoint, and plot this feature for all endpoints.}

\item{endpt.order}{Default NULL. If pair.order="endpoint", specify character with endpoint name (from beam.specs$name, after the period).}

\item{n.col}{A numeric. Specify the number of columns for the plot layout; default NULL will use the number of omics types.}

\item{n.row}{A numeric. Specify the number of rows for the plot layout; default NULL will automatically define the number of rows after number of columns specified.}

\item{title.size}{A numeric. Specify the size of individual plot titles. Default is 10.}
}
\value{
A figure (ggarrange object)
}
\description{
plot_beam_clin produces a matrix of feature level clinical plots for a set. Users can specify which omic/endpoint pairs they want to see as well as the number of features from the set. Default is all omic/endpoint pairs and the top feature (smallest feature-level p-value).
}
\examples{
data(beam_stats)
test.pvals <- compute_set_pvalues(beam.stats=beam_stats)
test.feat.pvals <- compute_feature_pvalues(beam.stats=beam_stats)
plot.specs <- prep_beam_plot(beam.data=beam_stats$beam.data,
                             beam.specs=beam_stats$beam.specs)
test.plot <- plot_beam_clin(beam.result=beam_stats, beam.specs=plot.specs,
                            beam.set.pvals=test.pvals,
                            beam.feat.pvals=test.feat.pvals,
                            set.id="ENSG00000099810", gene.name="MTAP",
                            pair.type=NULL, number.pairs=1, n.col=4,
                            n.row=NULL, title.size=11,
                            pair.order="omic", endpt.order=NULL)
}
