#' Map of Pediatric Data from COG trial AALL0434
#'
#' Map between annotation and omic data for a subset of clinical data from
#'     pediatric and young adult t-lineage acute lymphoblastic leukmia patients
#'     in the Children's Oncology Group trial AALL0434, published in Liu et al.,
#'     2017 Nature Genetics
#'
#' @format ## `setdat`
#' A data frame with 40 rows and 3 columns
#' \describe{
#'   \item{set.id}{Ensembl ID that defines gene-feature set}
#'   \item{mtx.id}{Name of omic matrix where corresponding feature data can be found}
#'   \item{row.id}{Feature name in corresponding omic matrix}
#' }
#' @source <https://www.nature.com/articles/ng.3909>
"setdat"
