% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_bct.R
\name{draw_models}
\alias{draw_models}
\title{Plot the results of the BCT and kBCT functions}
\usage{
draw_models(lst)
}
\arguments{
\item{lst}{output of the BCT/kBCT function.}
}
\value{
plots of the BCT/kBCT output models.
}
\description{
This function plots the models produced by the BCT and kBCT functions.
}
\examples{

# Use the pewee dataset as an example:
q <- BCT(pewee, 5) # maximum depth of 5

draw_models(q)
r <- kBCT(pewee, 5, 3) 

# maximum depth of 5, and k = 3 (top 3 a posteriori most likely models)
draw_models(r)
}
\seealso{
\code{\link{show_tree}}, \code{\link{BCT}}, \code{\link{kBCT}}
}
