% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capitalizeStrings.R
\name{capitalizeStrings}
\alias{capitalizeStrings}
\title{Capitalize strings in a vector}
\usage{
capitalizeStrings(x, all.words = FALSE, lower.back = FALSE)
}
\arguments{
\item{x}{[\code{character(n)}]\cr
Vector of character elements to capitalize.}

\item{all.words}{[\code{logical(1)}]\cr
If \code{TRUE} all words of each vector element are capitalized.
\code{FALSE} capitalizes the first word of each vector element.}

\item{lower.back}{[\code{logical(1)}]\cr
\code{TRUE} lowers the back of each word or vector element (depends on \code{all.words}).}
}
\value{
Capitalized vector: [\code{character(n)}].
}
\description{
Capitalise first word or all words of a character vector.
Lower back of vector element or word, respectively.
}
\examples{
capitalizeStrings(c("the taIl", "wags The dOg", "That looks fuNny!"))
capitalizeStrings(c("the taIl", "wags The dOg", "That looks fuNny!")
, all.words = TRUE, lower.back = TRUE)
}

