% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_viz_shots_scatter.R
\name{do_viz_shots_scatter}
\alias{do_viz_shots_scatter}
\title{Visualization of the shots statistics}
\usage{
do_viz_shots_scatter(shots_stats, type, draw, size_lab_box = 2.8, size_lab_court = 3, 
                     size_point = 3, language = "English")
}
\arguments{
\item{shots_stats}{Shooting data associated with the filters given to \code{\link{do_shots_stats}}.}

\item{type}{Options are 'team' for team statistics, 'player' for player statistics and 
'all' for the whole league.}

\item{draw}{Logical. TRUE to add the shots in their coordinates. FALSE to add just the
number of mades and attempted field goals.}

\item{size_lab_box}{Size of the text indicating the overall percentages (they are inside a box).}

\item{size_lab_court}{Size of the text indicating the percentages by zone.}

\item{size_point}{Size of the points.}

\item{language}{Language of the titles. Valid options are 'English' and 'Spanish' so far.}
}
\value{
A plot.
}
\description{
Create a visualization of the left half of the court and annotates both the total and 
by zone shooting statistics. It can also show the location of each individual shot, 
with color-coding for makes and misses.
}
\examples{
\dontrun{
df0 <- do_divide_court_zones(acb_shooting_data_2425)

df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "")

shots_stats <- do_shots_stats(df1, df0) 

do_viz_shots_scatter(shots_stats, "all", FALSE) 
do_viz_shots_scatter(shots_stats, "all", TRUE)
}

}
\seealso{
\code{\link{do_divide_court_zones}}, \code{\link{do_filter_data}}, 
\code{\link{do_shots_stats}}
}
\author{
Guillermo Vinue
}
