% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraping_games_acb.R
\name{scraping_games_acb}
\alias{scraping_games_acb}
\title{ACB player game finder data}
\usage{
scraping_games_acb(code, game_id, season = "2020-2021", 
                   type_season = "Regular Season",
                   user_email, user_agent_goo)
}
\arguments{
\item{code}{Game code.}

\item{game_id}{Game id.}

\item{season}{Season, e.g. 2022-2023.}

\item{type_season}{Type of season, e.g. 'Regular season'.}

\item{user_email}{Email's user to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}

\item{user_agent_goo}{User-agent to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}
}
\value{
A data frame with the player game finder data (box score data).
}
\description{
This is the new function to obtain the ACB box score data.
}
\examples{
\dontrun{
# Not needed to scrape every time the package is checked, built and installed.
user_email <- "yours"       
user_agent_goo <- "yours" 
df1 <- scraping_games_acb("103350", 1, "2022_2023", "Regular Season",
                          user_email, user_agent_goo)
}                           

}
\seealso{
\code{\link{scraping_games_acb_old}}
}
\author{
Guillermo Vinue
}
