% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate}
\alias{climate}
\title{Climate Data}
\format{Scientists are interested in the Earth's temperature change since the last
glacial maximum, about 20,000 years ago. The first study to estimate the
temperature change was published in 1980, and estimated a change of -1.5 degrees
 C, +/- 1.2 degrees C in tropical sea surface temperatures.
 The negative value means that the Earth was colder then than now.
 Since 1980 there have been many other studies.
\code{climate} is a dataset with 63 measurements on 5 variables:
\describe{\item{\emph{deltaT}}{ the response variables, which is the change in temperature
in degrees Celsius;}
\item{\emph{sdev}}{a standard deviation for the calculated \emph{deltaT};}
\item{\emph{proxy}}{a number 1-8 reflecting which type of measurement system was used to derive
deltaT. Some proxies can be used over land, others over water.
The proxies are coded as\cr
1 "Mg/Ca"         \cr
2 "alkenone"      \cr
3 "Faunal"        \cr
4 "Sr/Ca"         \cr
5 "del 180"       \cr
6 "Ice Core"      \cr
7 "Pollen"        \cr
8 "Noble Gas"     \cr
}
\item{\emph{T/M}}{, an indicator of whether it was a terrestrial or marine study (T/M),
 which is coded as 0 for Terrestrial, 1 for Marine;}
\item{ \emph{latitude}}{the latitude where the data were collected.}}}
\source{
Data provided originally by Michael Lavine and available at \url{https://stat.duke.edu/sites/stat.duke.edu/files/climate.dat}
}
\description{
Climate Data
}
