% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{quantile.angmcmc}
\alias{quantile.angmcmc}
\title{Quantile estimates for parameters from an angmcmc object}
\usage{
\method{quantile}{angmcmc}(x, par.name = NULL, comp.label = NULL,
  burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{x}{angmcmc object}

\item{par.name}{vector of names of parameters for which point estimates are to be computed.  If \code{NULL}, results for all parameters are provided.}

\item{comp.label}{vector of component labels (positive integers, e.g., \code{1, 2, ...}) for which point estimates are to be computed.
If \code{NULL}, results for all components are provided.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{further arguments to pass to \code{quantile}.  In particular, \code{probs = seq(0, 1, 0.25)}
is the default vector of quantiles computed for each parameter.}
}
\value{
Returns a three dimensional array of quantiles, or a matrix (vector) of quantiles
 if one (or two) among \code{par.name},  \code{comp.label}, \code{probs} has length 1.
}
\description{
Quantile estimates for parameters from an angmcmc object
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# 0.025th quantiles
(quant_025 <- quantile(fit.vmsin.20, prob = 0.025))
# 0.975th quantiles
(quant_975 <- quantile(fit.vmsin.20, prob = 0.975))
# default quantiles
(quant_def <- quantile(fit.vmsin.20))

}
