% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_tags.R
\name{add_tags}
\alias{add_tags}
\alias{customvision_tags}
\alias{add_negative_tag}
\alias{list_tags}
\alias{get_tag}
\alias{remove_tags}
\title{Add, retrieve and remove tags for a project}
\usage{
add_tags(project, tags)

add_negative_tag(project, negative_name = "_negative_")

list_tags(project, as = c("names", "ids", "dataframe", "list"),
  iteration = NULL)

get_tag(project, name = NULL, id = NULL, iteration = NULL)

remove_tags(project, tags, confirm = TRUE)
}
\arguments{
\item{project}{A Custom Vision project.}

\item{tags}{For \code{add_tags}, a vector of strings to treat as tags.}

\item{negative_name}{For \code{add_negative_tag}, the label to provide a negative tag. See 'Negative tags' below.}

\item{as}{For \code{list_tags}, the format in which to return results: a vector of tag names, a vector of tag IDs, a data frame of metadata, or a list of metadata.}

\item{iteration}{For \code{list_tags} and \code{get_tag}, the iteration ID (roughly, which model generation to use). Defaults to the latest iteration.}

\item{name, id}{For \code{get_tag}, the name (text string) for a tag, and its ID. Provide one or the other, but not both.}

\item{confirm}{For \code{remove_tags}, whether to ask for confirmation first.}
}
\value{
\code{add_tags} and \code{add_negative_tag} return a data frame containing the names and IDs of the tags added.
}
\description{
Add, retrieve and remove tags for a project
}
\details{
\emph{Tags} are the labels attached to images for use in classification projects. An image can have one or multiple tags associated with it; however, the latter only makes sense if the project is setup for multi-label classification.

Tags form part of the metadata for a Custom Vision project, and have to be explicitly defined prior to use. Each tag has a corresponding ID which is used to manage it. In general, you can let AzureVision handle the details of managing tags and tag IDs.
}
\section{Negative tags}{

A \emph{negative tag} is a special tag that represents the absence of any other tag. For example, if a project is classifying images into cats and dogs, an image that doesn't contain either a cat or dog should be given a negative tag. This can be distinguished from an \emph{untagged} image, where there is no information at all on what it contains.

You can add a negative tag to a project with the \code{add_negative_tag} method. Once defined, a negative tag is treated like any other tag. A project can only have one negative tag defined.
}

\examples{
\dontrun{

add_tags(myproj, "newtag")
add_negative_tag(myproj)
remove_tags(myproj, "_negative_")
add_negative_tag(myproj, "nothing")

}
}
\seealso{
\code{\link{add_image_tags}}, \code{\link{remove_image_tags}}
}
