% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AzureVMmetadata.R
\docType{data}
\name{instance}
\alias{instance}
\alias{attested}
\alias{events}
\alias{update_instance_metadata}
\alias{update_attested_metadata}
\alias{update_scheduled_events}
\title{Metadata for an Azure VM}
\format{\code{instance}, \code{attested} and \code{events} are environments.}
\usage{
instance

attested

events

update_instance_metadata()

update_attested_metadata(nonce = NULL)

update_scheduled_events()
}
\arguments{
\item{nonce}{For \code{update_attested_metadata}, an optional string to use as a nonce.}
}
\value{
The updating functions return the contents of their respective environments as lists, invisibly.
}
\description{
Metadata for an Azure VM
}
\details{
The \code{instance}, \code{attested} and \code{events} environments contain the instance metadata, attested metadata, and scheduled events respectively for a VM running in Azure. \code{instance} and \code{attested} are automatically populated when you load the AzureVMmetadata package, or you can manually populate them yourself with the \code{update_instance_metadata} and \code{update_attested_metadata} functions. \code{events} is not populated at package startup, because calling the scheduled event service can require up to several minutes if it is not running already. You can manually populate it with the \code{update_scheduled_events} function.

If AzureVMmetadata is loaded in an R session that is \emph{not} running in an Azure VM, all the metadata environments will be empty.
}
\examples{

## these will only be meaningful when run in an Azure VM

# all compute metadata
AzureVMmetadata::instance$compute

# VM name and ID
AzureVMmetadata::instance$compute$name
AzureVMmetadata::instance$compute$vmId

# VM resource details: subscription, resource group, resource ID
AzureVMmetadata::instance$compute$subscriptionId
AzureVMmetadata::instance$compute$resourceGroupName
AzureVMmetadata::instance$compute$resourceId

# all network metadata
AzureVMmetadata::instance$network

# IPv4 address details (1st network interface)
AzureVMmetadata::instance$network$interface[[1]]$ipv4

}
\seealso{
\link{in_azure_vm}

\href{https://docs.microsoft.com/en-us/azure/virtual-machines/windows/instance-metadata-service}{Instance metadata service documentation}

To obtain OAuth tokens from the metadata service, see \link[AzureAuth:get_managed_token]{AzureAuth::get_managed_token}
}
\keyword{datasets}
